/**
 * Created by qjon on 11.01.14.
 */
'use strict';

angular.module('srodki_trwale', [])
    .factory('SrodekTrwaly', ['$http', '$rootScope', function($http, $rootScope){
        function SrodekTrwaly(data){
            this.setData(data);
        }

        SrodekTrwaly.prototype = {
            list : []
            ,_originalQuantity: 0
            ,_totalQuantity: 0
            ,_totalValue: 0
            ,addPosition: function(quantity, loanType, depreciation){
                this.list.push({
                    id: 0
                    ,item_id: this.id
                    ,round_id: roundId
                    ,price: this.buy_now_price
                    ,quantity: quantity
                    ,loan_type: loanType
                    ,depreciation: depreciation
                    ,_originalQuantity: 0
                });


                this._totalQuantity += quantity;
                this._totalValue += (quantity * this.buy_now_price);
            }
            ,setData: function(data){
                angular.extend(this, data.item);
                this.list = data.list;

                this.init();

            }
            ,init: function(){
                this._totalQuantity = 0;
                this._originalQuantity = 0;
                this._totalValue = 0;
                this.list.forEach(function(item){
                    this._totalQuantity += item.quantity;
                    this._totalValue += (item.quantity * item.price);

                    if(item.id > 0)
                    {
                        this._originalQuantity += item.quantity;
                        item._originalQuantity = item.quantity;
                    }
                }, this);
            }
            ,isChanged: function(){
                return (this._originalQuantity != this._totalQuantity);
            }
            ,save: function(){
                var scope = this;

                var message = {
                    title: 'Wyposażenie'
                    ,msg: 'Zapisuję dane. Proszę czekać...'
                };

                this.list.forEach(function(item){
                    if(item.round_id == roundId && item.quantity != item._originalQuantity)
                    {
                        $rootScope.$broadcast('Message:addMsg', message);

                        $http.post(appDev + '/front/rest/srodkiTrwale', item)
                            .success(function(data){
                                if(data == 'true')
                                {
                                    scope._originalQuantity -= item._originalQuantity;
                                    var index = scope.list.indexOf(item);
                                    if(index > -1)
                                    {
                                        scope.list.splice(index, 1);
                                    }
                                }
                                else
                                {
                                    item.id = data.id;
                                    scope._originalQuantity += data.quantity;
                                    item._originalQuantity = data.quantity;
                                }
                                $rootScope.$broadcast('Message:delMsg', message);
                            })
                            .error(function(data){
                                console.log('error');
                            })
                        ;
                    }

                })
            }
            ,isPlace: function(){
                return (this.type.symbol == 'OFFICE' || this.type.symbol == 'DEPOT' || this.type.symbol == 'STOCKROOM');
            }
        }
        return SrodekTrwaly;
    }])
    .factory('STCurrentList', ['$http', '$q', 'SrodekTrwaly', function($http, $q, SrodekTrwaly){

        var STCurrentList = {
            list: []
            ,_isLoadedData: false
            ,loadData: function(){
                if(this._isLoadedData)
                {
                    return this.list;
                }
                var deferer = $q.defer();
                var scope = this;
                $http.get(appDev + '/front/rest/srodkiTrwale')
                    .success(function(data){
                        scope.setData(data);
                        scope._isLoadedData = true;
                        deferer.resolve(scope.list);
                    })
                ;

                return deferer.promise;
            }
            ,setData: function(data){
                this.list = [];
                data.forEach(function(itemData){
                    this.list.push(new SrodekTrwaly(itemData));
                }, this);
            }
            ,findById: function(id){
                var found = false;
                for(var i = 0; i < this.list.length; i++){
                    if(this.list[i].id == id){
                        found = this.list[i];
                        break;
                    }
                }
                return found;
            }
            ,addItem: function(itemData, quantity, loanType, depreciation){
                var item = {
                    item: itemData
                    ,list: [
                        {
                            id: 0
                            ,item_id: itemData.id
                            ,round_id: roundId
                            ,price: itemData.buy_now_price
                            ,quantity: quantity
                            ,loan_type: loanType
                            ,depreciation: depreciation
                        }
                    ]
                }
                var Item = new SrodekTrwaly(item);
                this.list.push(Item);
                return Item;
            }
            ,isAnyChanged: function(){
                var isChanged = false;
                for(var i = 0; i < this.list.length; i++)
                {
                    if(this.list[i].isChanged())
                    {
                        isChanged = true;
                        break;
                    }
                }
                return isChanged;
            }
        }

        return STCurrentList;
    }])
    .factory('STList', [function(){

        var STList = {
            list: []
            ,types: [
                {name: 'Pojazdy', symbol: 'MOTO'}
                ,{name: 'Komputery', symbol: 'KOMP'}
                ,{name: 'Telefony', symbol: 'PHONE'}
                ,{name: 'Inne', symbol: 'OTHER'}
            ]
            ,setData: function(data){
                this.list = data;
            }
        }

        return STList;
    }])
;